# 智能网申助手 Chrome 扩展

一个帮助应届生自动填写网申信息的Chrome扩展插件。

## 功能特点

- 📄 **简历解析**: 上传PDF/Word格式简历，自动提取个人信息
- 🔧 **智能填写**: 在网申页面自动识别并填写表单字段
- 💾 **数据存储**: 本地保存解析的简历信息
- 🎯 **精准匹配**: 支持中英文字段识别，覆盖常见网申表单

## 安装方法

### 方法一：开发者模式安装

1. 下载或克隆此项目到本地
2. 打开Chrome浏览器，进入 `chrome://extensions/`
3. 开启右上角的"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择项目文件夹
6. 扩展安装完成！

### 方法二：生成图标文件（可选）

1. 在浏览器中打开 `create_icon.html`
2. 页面会自动下载4个不同尺寸的图标文件
3. 将下载的图标文件放入 `icons/` 文件夹

## 使用说明

### 1. 上传简历

- 点击Chrome工具栏中的扩展图标
- 点击"选择简历文件"按钮
- 选择PDF或Word格式的简历
- 等待自动解析完成

### 2. 管理信息

- 在弹出窗口中查看和编辑解析的信息
- 可以手动添加或修改个人信息
- 支持添加多段实习经历
- 点击"保存信息"保存修改

### 3. 自动填写

- 在网申页面打开扩展插件
- 点击"智能填写"按钮
- 插件会自动识别表单字段并填写
- 支持的字段类型：
  - 个人信息：姓名、电话、邮箱
  - 教育背景：学校、专业、学历
  - 实习经历：公司、职位、时间、描述
  - 获奖情况：奖项、荣誉

## 支持的表单字段

插件能够识别以下类型的表单字段（支持中英文）：

| 信息类型 | 支持的字段名称 |
|---------|---------------|
| 姓名 | 姓名、真实姓名、name、realname、username |
| 电话 | 电话、手机、联系方式、phone、mobile |
| 邮箱 | 邮箱、电子邮箱、email、e-mail |
| 学校 | 学校、毕业院校、school、university |
| 专业 | 专业、所学专业、major、specialty |
| 学历 | 学历、教育程度、education、degree |
| 获奖 | 获奖情况、荣誉奖项、awards、honors |

## 文件结构

```
├── manifest.json      # 扩展配置文件
├── popup.html         # 弹出窗口HTML
├── popup.js           # 弹出窗口逻辑
├── popup.css          # 弹出窗口样式
├── content.js         # 内容脚本（页面交互）
├── background.js      # 后台脚本
├── icons/            # 图标文件夹
└── README.md         # 说明文档
```

## 技术实现

- **Manifest V3**: 使用最新的Chrome扩展API
- **Content Scripts**: 在网页中注入脚本进行表单操作
- **Storage API**: 使用Chrome存储API保存用户数据
- **智能匹配**: 基于关键词和上下文的字段识别算法

## 隐私说明

- 所有数据仅存储在本地浏览器中
- 不会上传任何个人信息到服务器
- 简历解析在本地完成

## 注意事项

1. 目前简历解析功能使用模拟数据，实际使用时需要集成真实的解析服务
2. 部分网站可能有反自动填写机制，请遵守网站使用条款
3. 建议在填写后检查信息准确性

## 开发计划

- [ ] 集成真实的简历解析API
- [ ] 支持更多文件格式
- [ ] 添加表单字段映射配置
- [ ] 优化字段识别准确率
- [ ] 添加批量网申功能

## 贡献指南

欢迎提交Issue和Pull Request来帮助改进这个项目！

## 许可证

MIT License