/*
 *  Copyright (c) 2023 Rockchip Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _RK_AIQ_PARAM_SHARP34_H_
#define _RK_AIQ_PARAM_SHARP34_H_

#define SHARP_ISO_STEP_MAX                  13
#define SHARP_FILTPIXGAINCURVE_SEGMENT_MAX     14
#define SHARP_RADIDISTCURVE_SEGMENT_MAX        22
#define SHARP_TXETCURVE_SEGMENT_MAX        17

typedef enum sharp_locSgmStrg_mode_e {
    // @reg: hw_sharp_localGain_bypass == 0
    // @note: "Mixed mode of local and global input pix sigma"
    sharp_locGlbSgmStrgMix_mode = 0,
    // @reg: hw_sharp_localGain_bypass == 1
    // @note: "Only global input pix sigma"
    sharp_glbSgmStrgOnly_mode = 1
} sharp_locSgmStrg_mode_t;

typedef struct sharp_locSgmStrg_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_localGain_bypass),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_locSgmStrg_mode_t),
        M4_DEFAULT(sharp_locGlbSgmStrgMix_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(localSgmStrg_mode_group),
        M4_NOTES(The mode of sharp input pix sigma. Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_sharp_localGain_bypass
    // @para: exgain_bypass
    sharp_locSgmStrg_mode_t hw_sharpT_locSgmStrg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_global_gain),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,64.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,6,4),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The value of the global input pix sigma.\n
        Higher the value, the higher the global input pix sigma value.\n
        Freq of use: low))  */
    // @reg: sw_sharp_global_gain
    // @para: global_gain
    float hw_sharpT_glbSgmStrg_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_cnr_global_gain_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_GROUP(localSgmStrg_mode_group:sharp_locGlbSgmStrgMix_mode),
        M4_NOTES(The wgt of the global input pix sigma is used in the fusion operation with the local input pix sigma.\n
        The higher the value, the wgt of bifilted pixel is higher.\n
        Freq of use: low))  */
    // @reg: sw_cnr_global_gain_alpha
    // @para: global_gain_alpha
    float hw_sharpT_glbSgmStrg_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_local_gainscale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(localSgmStrg_mode_group:sharp_locGlbSgmStrgMix_mode),
        M4_NOTES(The scaling factor of the local input pix sigma.\n
        Higher the value, the higher the local input pix sigma value.\n
        Freq of use: high))  */
    // @reg: sw_sharp_local_gainscale
    // @para: local_gainscale
    float hw_sharpT_localSgmStrg_scale;
} sharp_locSgmStrg_dyn_t;

typedef enum sharp_filtCfg_mode_e {
    // @note: The filter coefficients for configuring filters are generated by inputting  filter strength into the formula
    // @para: kernel_sigma_enable == 1
    sharp_cfgByFiltStrg_mode = 0,
    // @note: The filter coefficients for configuring filters are directly input.
    // @para: kernel_sigma_enable == 0
    sharp_cfgByFiltCoeff_mode = 1
} sharp_filtCfg_mode_t;

typedef enum sharp_shpSrc_mode_e {
    // @para: hw_sharp_baseImg_sel == 0
    sharp_hfExactPreBfOut_mode = 0,
    // @para: hw_sharp_baseImg_sel == 1
    sharp_sharpIn_mode = 1,
} sharp_shpSrc_mode_t;

typedef enum sharp_shpOpt_mode_s {
    // @para: hw_sharp_texWgt_mode == 0
    sharp_allShpSclEn_mode = 0,
    // @para: hw_sharp_texWgt_mode == 1
    sharp_texShpSclDis_othrEn_mode = 1,
    // @para: hw_sharp_texWgt_mode == 2
    sharp_texShpScl_othrDis_mode = 2,
    // @para: hw_sharp_texWgt_mode == 3
    sharp_texShpSclDebugOut_mode = 3
} sharp_shpOpt_mode_t;

typedef enum sharp_bwEdg_mode_e {
    // @para: hw_sharp_clipIdx_sel == 0"
    sharp_orgPix_mode = 0,
    // @para: hw_sharp_clipIdx_sel == 1
    sharp_lpfPix_mode,
} sharp_bwEdg_mode_t;

typedef struct sharp_sigmaCurve_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(idx),
        M4_TYPE(u16),
        M4_UI_PARAM(data_x),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,1024),
        M4_DEFAULT([0, 64, 128, 256, 384, 640, 896, 1024]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    uint16_t idx[8];
    /* M4_GENERIC_DESC(
        M4_ALIAS(val),
        M4_TYPE(u16),
        M4_UI_PARAM(data_y),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(1,1023),
        M4_DEFAULT([32, 40, 48, 56, 64, 56, 48, 40]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO.\n
        Freq of use: low))  */
    uint16_t val[8];
} sharp_sigmaCurve_t;

typedef struct sharp_sharpOpt_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_baseImg_sel),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_shpSrc_mode_t),
        M4_DEFAULT(sharp_hfExactPreBfOut_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The clip mode of hf data after sharp operation.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_sharp_baseImg_sel
    sharp_shpSrc_mode_t hw_sharpT_shpSrc_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_texWgt_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_shpOpt_mode_t),
        M4_DEFAULT(sharp_allShpSclEn_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(shpOpt_mode_group),
        M4_NOTES(The clip mode of hf data after sharp operation.\n
        Reference enum types.\n
        Freq of use: high))  */
    // @reg: hw_sharp_texWgt_mode
    sharp_shpOpt_mode_t hw_sharpT_shpOpt_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(imgLpf0_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,31.275),
        M4_DEFAULT(8.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,5,2),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        The para control the local sharp strg of the img based on the pix radius distance.
        Freq of use: high))  */
    // @reg: hw_sharp_globalSharp_strg
    // @para: sharp_ratio
    float hw_sharpT_hfHiGlbShpScl_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(imgLpf1_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,31.275),
        M4_DEFAULT(8.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,5,2),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        The para control the local sharp strg of the img based on the pix radius distance.
        Freq of use: high))  */
    // @reg: hw_sharp_globalSharp_strg
    // @para: sharp_ratio
    float hw_sharpT_hfMidGlbShpScl_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_gain2strg_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,14),
        M4_RANGE_EX(0,32.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,6,9),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 1, 2, 4, 8, 16, 24, 32, 48, 64, 128, 256, 512, 1024]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpSclDis_othrEn_mode),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        The para control the local sharp strg of the img based on the pix radius distance.
        Freq of use: high))  */
    // @reg: hw_sharp_gain2strg_val0~13
    float hw_sharpT_locSgmStrg2ShpScl_val[SHARP_FILTPIXGAINCURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_distance2strg_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,22),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21]),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpSclDis_othrEn_mode),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        Higher the value, the local sharp strg of the img is higher.
        Freq of use: high))  */
    // @reg: hw_sharp_distance2strg_val0~21
    // @para: dis_adj_sharp_strength
    float hw_sharpT_radiDist2ShpScl_val[SHARP_RADIDISTCURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_detail2strg_val),
        M4_TYPE(u16),
        M4_SIZE_EX(1,17),
        M4_RANGE_EX(0,1024),
        M4_DEFAULT([0, 3, 30, 104, 224, 372, 528, 672, 791, 882, 945, 985, 1008, 1019, 1023, 1024, 1024]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 64, 128, 192, 256, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024]),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpSclDis_othrEn_mode),
        M4_NOTES(TODO\n
        Freq of use: high))  */
    // @reg: hw_sharp_detail2strg_val0~7
    uint16_t hw_sharpT_hfScl2ShpScl_val[17];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_texReserve_level),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0.0,31.0),
        M4_DEFAULT(1),
        M4_DIGIT_EX(3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpScl_othrDis_mode|sharp_texShpSclDebugOut_mode),
        M4_NOTES( POW(2, hw_sharpT_texture2SharpWgt_norizeMax) is the max limit of texture in the normalization operation for texture wgt.\n
        Higher the value, the lower the sharpening intersity of the weak texture.\n
        Freq of use: high))  */
    // @reg: hw_sharp_texReserve_level, hw_sharp_tex_scale
    float hw_sharpT_tex2ShpScl_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_tex2wgt_en),
        M4_TYPE(bool),
        M4_DEFAULT(0),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP_CTRL(textShpSclRemap_en_group),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpScl_othrDis_mode|sharp_texShpSclDebugOut_mode),
        M4_NOTES(....
        Freq of use: high))  */
    // reg: hw_sharp_tex2wgt_en;
    bool hw_sharpT_texShpSclRemap_en;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_tex2wgt_val),
        M4_TYPE(u16),
        M4_SIZE_EX(1,17),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1023),
        M4_DIGIT_EX(1),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 64, 128, 192, 256, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024]),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpScl_othrDis_mode|sharp_texShpSclDebugOut_mode;textShpSclRemap_en_group),
        M4_NOTES( ....\n
        Higher the value, the lower the sharpening intersity of the weak texture.\n
        Freq of use: high))  */
    // @reg: sw_sharp_tex2wgt_val0~16
    uint16_t hw_sharpT_texShpSclRemap_val[SHARP_TXETCURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_clipIdx_sel),
        M4_TYPE(enum),
        M4_ENUM_DEF(),
        M4_DEFAULT(sharp_orgPix_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The clip mode of hf data after sharp operation.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_sharp_clipIdx_sel
    sharp_bwEdg_mode_t sw_sharpT_bwEdgClipIdx_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_luma2posClip_val),
        M4_TYPE(u16),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(256),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 64, 128, 256, 384, 640, 896, 1024]),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The limit of hf data is based on luma in the clip operation.\n
        The higher value, the higer range for sharp.\n
        Freq of use: high))  */
    // @reg: hw_sharp_luma2posClip_val0~7
    uint16_t hw_sharpT_luma2WhtEdg_maxLimit[8];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_luma2negClip_val),
        M4_TYPE(u16),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(256),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 64, 128, 256, 384, 640, 896, 1024]),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The limit of hf data is based on luma in the clip operation.\n
        The higher value, the higer range for sharp.\n
        Freq of use: high))  */
    // @reg: hw_sharp_luma2negClip_val0~7
    uint16_t hw_sharpT_luma2BkEdg_maxLimit[8];
} sharp_sharpOpt_dyn_t;

typedef struct sharp_hfExtra_preBifilt_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(kernel_sigma_enable),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtCfg_mode_t),
        M4_DEFAULT(sharp_cfgByFiltStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(pbft_filtCfg_mode_group),
        M4_NOTES(The config mode of pre bifilter used for hi-freq pre filtering processing of input pixels of the sharp module.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgByFiltStrg_mode
    sharp_filtCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_preBifilt_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,256.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(pbft_filtCfg_mode_group:sharp_cfgByFiltStrg_mode),
        M4_NOTES(The spatial wgt of pre bifilter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: sw_sharp_preBifilt_coeff0~sw_sharp_preBifilt_coeff2
    // @para: prefilter_sigma
    float sw_sharpT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_preBifilt_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,3),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(pbft_filtCfg_mode_group:sharp_cfgByFiltCoeff_mode),
        M4_NOTES(The spatial filter kernel of bifilter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] == 1.0 .\n
        Freq of use: low))  */
    // @reg: sw_sharp_preBifilt_coeff0~sw_sharp_preBifilt_coeff2
    // @para: prefilter_coeff
    float hw_sharpT_filtSpatial_wgt[3];
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_preBifilt_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the range sigma of pre bifilter.\n
        Higher the value, the stronger denoise strength of pre bifilter.
        Freq of use: high))  */
    // @reg: hw_sharp_preBifilt_vsigma_inv0~7
    // @para: sw_sharp_preBifilt_scale
    float sw_sharpT_rgeSgm_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_preBifilt_offset),
        M4_TYPE(u8),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The offset of the range sigma of pre bifilter.\n
        Higher the value, the stronger denoise strength of pre bifilter.
        Freq of use: low))  */
    // @reg: hw_sharp_preBifilt_vsigma_inv0~7
    // @para: sw_sharp_preBifilt_offset
    uint8_t sw_sharpT_rgeSgm_offset;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_preBifilt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of pre bifilted pixel is used in the fusion operation between the pre bifilted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of pre bilateral filter.
        Freq of use: high))  */
    // @reg: sw_sharp_preBifilt_alpha
    // @para: sw_sharp_preBifilt_alpha
    float hw_sharpT_bifiltOut_alpha;
} sharp_hfExtra_preBifilt_dyn_t;

typedef enum sharp_hfExtra_lpfCfg_mode_e {
    // @note: Users can control the generation of the final hardware low-pass filter operator by configuring the low-pass filter strengths of two different frequency bands.
    sharp_cfgBy2SwLpfStrg_mode = 0,
    // @note: The filter coefficients for configuring filters are directly input.
    sharp_cfgByHwLpfCoeff_mode = 1
} sharp_hfExtra_lpfCfg_mode_t;

typedef struct sharp_hfExtra_lpf_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(kernel_sigma_enable),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_hfExtra_lpfCfg_mode_t),
        M4_DEFAULT(sharp_cfgBy2SwLpfStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(lpf_filtCfg_mode_group),
        M4_NOTES(The config mode of gaus filter is lpf for input pixels  of the sharp module.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgBy2SwLpfStrg_mode
    sharp_hfExtra_lpfCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(imgLpf0_rsigma),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,256.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(lpf_filtCfg_mode_group:sharp_cfgBy2SwLpfStrg_mode),
        M4_NOTES(The spatial wgt of gaus filter is operator from the strength value. Only valid on sharp_cfgBy2SwLpfStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: sw_sharp_imgLpf_coeff0~5
    // @para: GaussianFilter_sigma
    float sw_sharpT_hfHi_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(imgLpf1_rsigma),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,256.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(lpf_filtCfg_mode_group:sharp_cfgBy2SwLpfStrg_mode),
        M4_NOTES(The spatial wgt of gaus filter is operator from the strength value. Only valid on sharp_cfgBy2SwLpfStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: sw_sharp_imgLpf_coeff0~5
    // @para: GaussianFilter_sigma
    float sw_sharpT_hfMid_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_imgLpf_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,6),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751,0,0,0]),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,0,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(lpf_filtCfg_mode_group:sharp_cfgByHwLpfCoeff_mode),
        M4_NOTES(The spatial filter kernel of gaus filter . Only valid on sharp_cfgByHwLpfCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] + 4*coeff[3] + 8*coeff[4] + 4*coeff[5] == 1.\n
        Freq of use: low))  */
    // @reg: sw_sharp_imgLpf_coef_0~5
    // @para: GaussianFilter_coeff
    float hw_sharpT_lpf_wgt[6];
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_guideFilt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of gaus filted pixel is used in the fusion operation between the filted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of gaus filter.
        Freq of use: high))  */
    // @reg: sw_sharp_guideFilt_alpha
    float hw_sharpT_lpfOut_alpha;
} sharp_hfExtra_lpf_dyn_t;

typedef struct sharp_hfExtra_hfBifilt_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(kernel_sigma_enable),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtCfg_mode_t),
        M4_DEFAULT(sharp_cfgByFiltStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(hfBft_filtCft_mode_group),
        M4_NOTES(The config mode of bifilter used for hi-freq data that generated from pre bifilter and gaus filter.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgByFiltStrg_mode
    sharp_filtCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_detailBifilt_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,256.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(hfBft_filtCft_mode_group:sharp_cfgByFiltStrg_mode),
        M4_NOTES(The spatial wgt of bifilter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: high))  */
    // @reg: sw_sharp_detailBifilt_coeff0~sw_sharp_detailBifilt_coeff2
    // @para: sw_sharp_detailBifilt_rsigma
    float sw_sharpT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_detailBifilt_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,3),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(hfBft_filtCft_mode_group:sharp_cfgByFiltCoeff_mode),
        M4_NOTES(The spatial filter kernel of bifilter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] == 1.0.\n
        Freq of use: low))  */
    // @reg: sw_sharp_detailBifilt_coeff0~sw_sharp_detailBifilt_coeff2
    // @para: hfBilateralFilter_coeff
    float hw_sharpT_filtSpatial_wgt[3];
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_detailBifilt_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,3,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the range sigma of bilateral filter.\n
        Higher the value, the stronger denoise strength of bilateral filter.
        Freq of use: high))  */
    // @reg: hw_sharp_detailBifilt_vsigma_inv0~7
    // @para: sw_sharp_detailBifilt_scale
    float sw_sharpT_rgeSgm_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_detailBifilt_offset),
        M4_TYPE(u8),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The offset of the range sigma of bilateral filter.\n
        Higher the value, the stronger denoise strength of bilateral filter.
        Freq of use: low))  */
    // @reg: hw_sharp_detailBifilt_vsigma_inv0~7
    // @para: sw_sharp_detailBifilt_offset
    uint8_t sw_sharpT_rgeSgm_offset;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharp_detailBifilt_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of bifilted pixel is used in the fusion operation between the filted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of bilateral filter.\n
        Freq of use: high))  */
    // @reg: sw_sharp_detailBifilt_alpha
    // @para: detail_bifilt_alpha
    float hw_sharpT_biFiltOut_alpha;
} sharp_hfExtra_hfBifilt_dyn_t;

typedef struct sharp_hfExtra_sigmaEnv_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_detailBifilt_vsigma),
        M4_TYPE(struct),
        M4_UI_MODULE(curve_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(The range sigma curve of bifilter.\n
        Freq of use: low))  */
    // @reg: hw_sharp_preBifilt_vsigma_inv0~7, hw_sharp_detailBifilt_vsigma_inv0~7
    sharp_sigmaCurve_t sw_sharpC_luma2Sigma_curve;
} sharp_hfExtra_sigmaEnv_dyn_t;


typedef enum sharp_estNsClip_mode_s {
    // @note: sw_sharp_noiseClip_sel == 0
    sharp_preNsSgmStats_mode = 0,
    // @note: sw_sharp_noiseClip_sel == 1
    sharp_setManual_mode = 1
} sharp_estNsClip_mode_t;

typedef enum sharp_estNsFilt_mode_s {
    // @note: sw_sharp_noiseFilt_sel == 0
    sharp_allFilt_mode = 0,
    // @note: sw_sharp_noiseFilt_sel == 1
    sharp_nhoodFiltOnly_mode = 1
} sharp_estNsFilt_mode_t;

typedef struct sharp_shpScl_texDct_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_noiseclip_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(hw_sharpT_nsPredFilt_mode),
        M4_DEFAULT(sharp_nhoodFiltOnly_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The mode of the noise sigma limit source. The noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma. \n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_sharp_noiseclip_mode
    sharp_estNsFilt_mode_t hw_sharpT_estNsFilt_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_noiseNorm_bit),
        M4_TYPE(u16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,10),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO\n
        Freq of use: low))  */
    // @reg: hw_sharp_noiseNorm_bit
    uint16_t hw_sharpT_estNsNorize_shift;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_noiseclip_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_nsPredClip_mode_t),
        M4_DEFAULT(sharp_setManual_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_GROUP_CTRL(estNsClip_mode_group),
        M4_NOTES(The mode of the noise sigma limit source. The noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma. \n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: hw_sharp_noiseclip_mode
    sharp_estNsClip_mode_t hw_sharpT_estNsClip_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_noise_maxLimit),
        M4_TYPE(u16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_GROUP(estNsClip_mode_group:sharp_setManual_mode),
        M4_NOTES(The max limit of noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma. Only valid on  sharp_fromSetManual_mode\n
        Higher the value, the harder it is to classify as texture.\n
        Freq of use: high))  */
    // @reg: hw_sharp_noise_maxLimit
    uint16_t hw_sharpT_estNsManual_maxLimit;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_noise_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,15.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,4,10),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma.\n
        Higher the value, the lower the sharpening intersity of the texture.\n
        Freq of use: high))  */
    // @reg: hw_sharp_noise_strg
    float hw_sharpT_estNs_scale;
} sharp_shpScl_texDct_dyn_t;

typedef struct sharp_shpScl_hf_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_luma2strg_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1023),
        M4_HIDE_EX(0),
        M4_UI_MODULE(curve),
        M4_DATAX([0, 64, 128, 256, 384, 640, 896, 1024]),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO\n
        Freq of use: high))  */
    // @reg: hw_sharp_luma2strg_val0~7
    float hw_sharpT_luma2hfScl_val[8];
} sharp_shpScl_hf_dyn_t;

typedef struct sharp_radiDist_static_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_center_x),
        M4_TYPE(s16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(-1000,1000),
        M4_DEFAULT(0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The x-coordinates of the optical center in the image\n
        (0,0) is the img center. (-1000,-1000) is the img left top corner. (1000,1000) is the img right bottom corner\n
        Freq of use: low))  */
    // @reg: hw_sharp_center_x
    // @para: Center_Mode
    int16_t hw_sharpCfg_opticCenter_x;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharp_center_y),
        M4_TYPE(s16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(-1000,1000),
        M4_DEFAULT(0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The y-coordinates of the optical center in the image\n
        (0,0) is the img center. (-1000,-1000) is the img left top corner. (1000,1000) is the img right bottom corner\n
        Freq of use: low))  */
    // @reg: hw_sharp_center_y
    // @para: Center_Mode
    int16_t hw_sharpCfg_opticCenter_y;
} sharp_radiDist_static_t;


typedef struct sharp_params_static_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(shpScl_radiDist),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_radiDist_static_t shpScl_radiDist;
} sharp_params_static_t;

typedef struct sharp_params_dyn_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sigmaEnv),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_hfExtra_sigmaEnv_dyn_t hfExtra_sgmEnv;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hfExtra_preBifilt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_hfExtra_preBifilt_dyn_t hfExtra_preBifilt;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hfExtra_lpf),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_hfExtra_lpf_dyn_t hfExtra_lpf;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hfExtra_hfBifilt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_hfExtra_hfBifilt_dyn_t hfExtra_hfBifilt;
    /* M4_GENERIC_DESC(
        M4_ALIAS(shpScl_hf),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpSclDis_othrEn_mode),
        M4_NOTES(TODO))  */
    sharp_shpScl_hf_dyn_t shpScl_hf;
    /* M4_GENERIC_DESC(
        M4_ALIAS(shpScl_inPixSgm),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpSclDis_othrEn_mode),
        M4_NOTES(TODO))  */
    sharp_locSgmStrg_dyn_t shpScl_locSgmStrg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(shpScl_texDct),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_GROUP(shpOpt_mode_group:sharp_allShpSclEn_mode|sharp_texShpScl_othrDis_mode|sharp_texShpSclDebugOut_mode)
        M4_NOTES(TODO))  */
    sharp_shpScl_texDct_dyn_t shpScl_texDetect;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sharpOpt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_sharpOpt_dyn_t sharpOpt;
} sharp_params_dyn_t;

typedef struct sharp_param_s {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sta),
        M4_TYPE(struct),
        M4_UI_MODULE(static_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_params_static_t sta;
    /* M4_GENERIC_DESC(
        M4_ALIAS(dyn),
        M4_TYPE(struct),
        M4_UI_MODULE(dynamic_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_params_dyn_t dyn;
} sharp_param_t;

#endif
