/*
 * rk_aiq_param_sharp32.h
 *
 *  Copyright (c) 2023 Rockchip Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _RK_AIQ_PARAM_SHARP32_H_
#define _RK_AIQ_PARAM_SHARP32_H_

#define SHARP_ISO_STEP_MAX                  13
#define SHARP_FILTPIXGAINCURVE_SEGMENT_MAX     14
#define SHARP_RADIDISTCURVE_SEGMENT_MAX        22

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpCfg_opticalCenterX_offset),
        M4_TYPE(s16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(-1000,1000),
        M4_DEFAULT(0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The x-coordinates of the optical center in the image\n
        (0,0) is the img center. (-1000,-1000) is the img left top corner. (1000,1000) is the img right bottom corner\n
        Freq of use: low))  */
    // @reg: sw_sharp_center_wid
    // @para: Center_Mode
    int16_t hw_sharpCfg_opticCenterX_coord;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpCfg_opticalCenterY_offset),
        M4_TYPE(s16),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(-1000,1000),
        M4_DEFAULT(0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The y-coordinates of the optical center in the image\n
        (0,0) is the img center. (-1000,-1000) is the img left top corner. (1000,1000) is the img right bottom corner\n
        Freq of use: low))  */
    // @reg: sw_sharp_center_het
    // @para: Center_Mode
    int16_t hw_sharpCfg_opticCenterY_coord;
} sharp_opticCenterCfg_t;

typedef enum {
    // @reg: sw_sharp_exgain_bypass == 0
    // @para: exgain_bypass == 0
    // @note: "Mixed mode of local and global input pix sigma"
    sharp_inPixSgmLocalGlbMix_mode = 0,
    // @reg: sw_sharp_exgain_bypass == 1
    // @para: exgain_bypass == 1
    // @note: "Only global input pix sigma"
    sharp_inPixSgmGlb_mode = 1
} sharp_inPixSgm_mode_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_inputPixSgm_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_inputPixSgm_mode_t),
        M4_DEFAULT(sharp_inPixSgmLocalGlbMix_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The mode of sharp input pix sigma. Reference enum types.\n Freq of use: low))  */
    // @reg: sw_sharp_exgain_bypass
    // @para: exgain_bypass
    sharp_inPixSgm_mode_t hw_sharpT_inPixSgm_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_glbPixSgm_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,64.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,6,4),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The value of the global input pix sigma.\n
        Higher the value, the higher the global input pix sigma value.
        Freq of use: low))  */
    // @reg: sw_sharp_global_gain
    // @para: global_gain
    float hw_sharpT_glbPixSgm_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_glbPixSgm_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(The wgt of the global input pix sigma is used in the fusion operation with the local input pix sigma.\n
        The higher the value, the wgt of bifilted pixel is higher.\n
        Freq of use: low))  */
    // @reg: sw_cnr_global_gain_alpha
    // @para: global_gain_alpha
    float hw_sharpT_glbPixSgm_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_localPixSgm_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the local input pix sigma.\n
        Higher the value, the higher the local input pix sigma value.
        Freq of use: low))  */
    // @reg: sw_sharp_local_gainscale
    // @para: local_gainscale
    float hw_sharpT_localPixSgm_scale;
}sharp_inPixSgm_dyn_t;

typedef enum {
    // @note: The filter coefficients for configuring filters are generated by inputting  filter strength into the formula
    // @para: kernel_sigma_enable == 1
    sharp_cfgByFiltStrg_mode = 0,
    // @note: The filter coefficients for configuring filters are directly input.
    // @para: kernel_sigma_enable == 0
    sharp_cfgByFiltCoeff_mode = 1
} sharp_filtCfg_mode_t;

typedef enum {
    // @note: The filter kernel is 3x3
    // @para: GaussianFilter_radius == 1
    sharp_filt3_mode = 0,
    // @note: The filter kernel is 5x5
    // @para: GaussianFilter_radius == 2
    sharp_filt5_mode = 1
} sharp_filtSpatialRadius_mode_t;


typedef enum {
    // @para: global_hf_clip_pos == 0
    sharp_clipBaseOnLuma_mode = 0,
    // @para: global_hf_clip_pos == 1
    sharp_clip256_mode = 1,
    // @para: global_hf_clip_pos == 2
    sharp_clip512_mode = 2
}sharp_hfSharpClip_mode_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(idx),
        M4_TYPE(u16),
        M4_UI_PARAM(data_x),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,65535),
        M4_DEFAULT(0),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO))  */
    uint16_t idx[8];
    /* M4_GENERIC_DESC(
        M4_ALIAS(idx),
        M4_TYPE(u16),
        M4_UI_PARAM(data_y),
        M4_SIZE_EX(1,8),
        M4_RANGE_EX(0,65535),
        M4_DEFAULT(0),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO))  */
    uint16_t val[8];
} sharp_sigmaCurve_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_hfSharpGlb_wgt),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,31.275),
        M4_DEFAULT(8.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,5,2),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        The para control the local sharp strg of the img based on the pix radius distance.
        Freq of use: high))  */
    // @reg: sw_sharp_sharp_ratio
    // @para: sharp_ratio
    float hw_sharpT_hfGlbShpWgt_val;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_pixSgm2ShpWgt_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,14),
        M4_RANGE_EX(0,32.0),
        M4_DEFAULT(0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,6,9),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        The para control the local sharp strg of the img based on the pix radius distance.
        Freq of use: high))  */
    // @reg: sw_sharp_gain_adj0 ~ sw_sharp_gain_adj16
    // @para: gain_adj_sharp_strength
    float hw_sharpT_pixSgm2ShpWgt_val[SHARP_FILTPIXGAINCURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_radiDist2SharpWgt_val),
        M4_TYPE(f32),
        M4_SIZE_EX(1,22),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The sharp strength is positively correlated with hfGlbSharpWgt, pixSgm2ShpWgt_val, radiDistSharpWgt and textureSharpWgt.\n
        Higher the value, the local sharp strg of the img is higher.
        Freq of use: high))  */
    // @reg: sw_sharp_strength0 ~ sw_sharp_strength21
    // @para: dis_adj_sharp_strength
    float hw_sharpT_radiDist2ShpWgt_val[SHARP_RADIDISTCURVE_SEGMENT_MAX];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_texture2SharpWgt_norizeMax),
        M4_TYPE(uint8_t),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,9),
        M4_DEFAULT(3),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( POW(2, hw_sharpT_texture2SharpWgt_norizeMax) is the max limit of texture in the normalization operation for texture wgt.\n
        Higher the value, the lower the sharpening intersity of the weak texture.\n
        Freq of use: high))  */
    // @reg: sw_sharp_enhance_bit
    // @para: enhance_bit
    uint8_t hw_sharpT_text2ShpWgt_norizeMax;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_hfSharpClip_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_hfSharpClip_mode_t),
        M4_DEFAULT(sharp_clipBaseOnLuma_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The clip mode of hf data after sharp operation.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: sw_sharp_strength21 bit [7:6]
    // @para: global_hf_clip_pos
    sharp_hfSharpClip_mode_t sw_sharpT_hfShpClip_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_luma2hfSharpLimit_val),
        M4_TYPE(uint16_t),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,9),
        M4_DEFAULT(3),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES( The limit of hf data is based on luma in the clip operation.\n
        The higher value, the higer range for sharp.\n
        Freq of use: high))  */
    // @reg: sw_sharp_clip_hf_0~7
    // @para: hf_clip
    uint16_t hw_sharpT_luma2hfShpLimit_val[8];
}sharp_sharpOpt_dyn_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtCfg_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtCfg_mode_t),
        M4_DEFAULT(sharp_cfgByFiltStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The config mode of pre bifilter used for hi-freq pre filtering processing of input pixels of the sharp module.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgByFiltStrg_mode
    sharp_filtCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtSpatial_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,100.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial wgt of pre bifilter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: low))  */
    // @reg: sw_sharp_pbf_coef_0~sw_sharp_pbf_coef_2
    // @para: prefilter_sigma
    float sw_sharpT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_filtSpatial_wgt),
        M4_TYPE(f32),
        M4_SIZE_EX(1,3),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial filter kernel of bifilter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] == 1.0 .\n
        Freq of use: low))  */
    // @reg: sw_sharp_pbf_coef_0~sw_sharp_pbf_coef_2
    // @para: prefilter_coeff
    float hw_sharpT_filtSpatial_wgt[3];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_biFiltOut_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of pre bifilted pixel is used in the fusion operation between the pre bifilted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of pre bilateral filter.
        Freq of use: low))  */
    // @reg: sw_sharp_pbf_ratio
    // @para: pbf_ratio
    float hw_sharpT_biFiltOut_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_rsigma_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the range sigma of pre bifilter.\n
        Higher the value, the stronger denoise strength of pre bifilter.
        Freq of use: low))  */
    // @reg: sw_sharp_pbf_sigma_inv_0~7 sw_sharp_pbf_sigma_inv_0~7
    // @para: pbf_gain
    float sw_sharpT_rsigma_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_rsigma_offset),
        M4_TYPE(uint8_t),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(4,15),
        M4_DEFAULT(1),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The offset of the range sigma of pre bifilter.\n
        Higher the value, the stronger denoise strength of pre bifilter.
        Freq of use: low))  */
    // @reg: sw_sharp_pbf_sigma_inv_0~7 sw_sharp_pbf_sigma_inv_0~7
    // @para: pbf_add
    uint8_t hw_sharpT_rsigma_offset;          //reg: sw_sharp_pbf_sigma_inv_0~sw_sharp_pbf_sigma_inv_7
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpC_luma2RSigma_curve),
        M4_TYPE(struct),
        M4_UI_MODULE(curve_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    // @reg: reg: sw_sharp_luma_dx1 ~ 7
    // @para: luma_point
    // @reg: sw_sharp_pbf_sigma_inv_0~7 sw_sharp_pbf_sigma_inv_0~7
    // @para: luma_sigma
    sharp_sigmaCurve_t hw_sharpC_luma2RSigma_curve;
}sharp_preBifilt_dyn_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtCfg_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtCfg_mode_t),
        M4_DEFAULT(sharp_cfgByFiltStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The config mode of gaus filter is lpf for input pixels  of the sharp module.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgByFiltStrg_mode
    sharp_filtCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtSpatialRadius_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtSpatialRadius_mode_t),
        M4_DEFAULT(sharp_filt5_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The config mode of filter spatial radius size. Only validate on sharp_cfgByFiltStrg_mode.\n
        Freq of use: low))  */
    // @para: GaussianFilter_radius
    sharp_filtSpatialRadius_mode_t sw_sharpT_filtSpatialRadi_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_gausFilt_Strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,100.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial wgt of gaus filter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: low))  */
    // @reg: sw_sharp_gaus_coef_0~sw_sharp_gaus_coef_5
    // @para: GaussianFilter_sigma
    float sw_sharpT_gausFilt_Strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_gausFilt_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,6),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751,0,0,0]),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,0,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial filter kernel of gaus filter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] + 4*coeff[3] + 8*coeff[4] + 4*coeff[5] == 1.\n
        Freq of use: low))  */
    // @reg: sw_sharp_gaus_coef_0~sw_sharp_gaus_coef_5
    // @para: GaussianFilter_coeff
    float hw_sharpT_gausFilt_coeff[6];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_gausFiltOut_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of gaus filted pixel is used in the fusion operation between the filted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of gaus filter.
        Freq of use: low))  */
    // @reg: sw_sharp_gaus_ratio
    // @para: gaus_ratio
    float hw_sharpT_gausFiltOut_alpha;
}sharp_gausFilt_dyn_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtCfg_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_filtCfg_mode_t),
        M4_DEFAULT(sharp_cfgByFiltStrg_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The config mode of bifilter used for hi-freq data that generated from pre bifilter and gaus filter.\n
        Reference enum types.\n
        Freq of use: low))  */
    // @para: kernel_sigma_enable  (kernel_sigma_enable == true) ->  sharp_cfgByFiltStrg_mode
    sharp_filtCfg_mode_t sw_sharpT_filtCfg_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_filtSpatial_strg),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,100.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,7,8),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial wgt of bifilter is operator from the strength value. Only valid on sharp_cfgByFiltStrg_mode.\n
        Higher the value, the higher spatial denoise strength.\n
        Freq of use: low))  */
    // @reg: sw_sharp_bf_coef_0~sw_sharp_bf_coef_2
    // @para: hfBilateralFilter_sigma
    float sw_sharpT_filtSpatial_strg;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_spatialFilt_coeff),
        M4_TYPE(f32),
        M4_SIZE_EX(1,3),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT([0.2042,0.1238,0.0751]),
        M4_DIGIT_EX(3),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The spatial filter kernel of bifilter . Only valid on sharp_cfgByFiltCoeff_mode.\n
        coeff[0] + 4*coeff[1] + 4*coeff[2] == 1.0.\n
        Freq of use: low))  */
    // @reg: sw_sharp_bf_coef_0~sw_sharp_bf_coef_2
    // @para: hfBilateralFilter_coeff
    float hw_sharpT_filtSpatial_wgt[3];
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_biFiltOut_alpha),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1.0),
        M4_DEFAULT(0.3),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,1,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The wgt of bifilted pixel is used in the fusion operation between the filted pixel and the original pixel.\n
        Higher the value, the stronger denoise strength of bilateral filter.\n
        Freq of use: low))  */
    // @reg: sw_sharp_bf_ratio
    // @para: bf_ratio
    float hw_sharpT_biFiltOut_alpha;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sw_sharpT_rsigma_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,4.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,3,7),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of the range sigma of bilateral filter.\n
        Higher the value, the stronger denoise strength of bilateral filter.
        Freq of use: low))  */
    // @reg: sw_sharp_bf_sigma_inv_0~7 sw_sharp_bf_sigma_inv_0~7
    // @para: bf_gain
    float sw_sharpT_rsigma_scale;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_rsigma_offset),
        M4_TYPE(uint8_t),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(4,15),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(2),
        M4_FP_EX(0,1,3),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The offset of the range sigma of bilateral filter.\n
        Higher the value, the stronger denoise strength of bilateral filter.
        Freq of use: low))  */
    // @reg: sw_sharp_bf_sigma_inv_0~7 sw_sharp_bf_sigma_inv_0~7
    // @para: bf_add
    uint8_t hw_sharpT_rsigma_offset;
    // @reg: reg: sw_sharp_luma_dx1 ~ 7
    // @reg: sw_sharp_bf_sigma_inv_0~7 sw_sharp_bf_sigma_inv_0~7
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpC_luma2RSigma_curve),
        M4_TYPE(struct),
        M4_UI_MODULE(curve_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(2),
        M4_NOTES(TODO))  */
    sharp_sigmaCurve_t hw_sharpC_luma2RSigma_curve;
}sharp_bifilt_dyn_t;

typedef enum {
    // @note: sw_sharp_noiseclip_mode == 0
    sharp_pixSgmStats_mode = 0,
    // @note: sw_sharp_noiseclip_mode == 1
    sharp_setManual_mode = 1
} sharp_noiseSgmLimit_mode_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_noiseSgmLimit_mode),
        M4_TYPE(enum),
        M4_ENUM_DEF(sharp_noiseSigmaLimit_mode_t),
        M4_DEFAULT(sharp_pixSgmStats_mode),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(The mode of the noise sigma limit source. The noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma. \n
        Reference enum types.\n
        Freq of use: low))  */
    // @reg: sw_sharp_noiseclip_mode
    // @para: noiseclip_mode
    sharp_noiseSgmLimit_mode_t hw_sharpT_noiseSgmLimit_mode;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_noiseSgm_maxLimit),
        M4_TYPE(uint16_t),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,1023),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(1),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The max limit of noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma. Only valid on  sharp_fromSetManual_mode\n
        Higher the value, the harder it is to classify as texture.\n
        Freq of use: low))  */
    // @reg: sw_sharp_noise_sigma
    // @para: noise_sigma_clip
    uint16_t hw_sharpT_noiseSgm_maxLimit;
    /* M4_GENERIC_DESC(
        M4_ALIAS(hw_sharpT_noiseSgm_scale),
        M4_TYPE(f32),
        M4_SIZE_EX(1,1),
        M4_RANGE_EX(0,10.0),
        M4_DEFAULT(1.0),
        M4_DIGIT_EX(4),
        M4_FP_EX(0,4,10),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(The scaling factor of noise sigma is used in formulas: Texture  = Pix sigma - Noise sigma.\n
        Higher the value, the lower the sharpening intersity of the texture.\n
        Freq of use: high))  */
    // @reg: sw_sharp_noise_strength
    // @para: noiseclip_strength
    float hw_sharpT_noiseSgm_scale;
}sharp_textureDct_dyn_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(opticCenter),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO))  */
	sharp_opticCenterCfg_t opticCenter;
} sharp_params_static_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(en),
        M4_TYPE(bool),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO))  */
    bool en;
    /* M4_GENERIC_DESC(
        M4_ALIAS(en),
        M4_TYPE(bypass),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(0),
        M4_NOTES(TODO))  */
    bool bypass;
    /* M4_GENERIC_DESC(
        M4_ALIAS(preBifilt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_preBifilt_dyn_t preBifilt;
    /* M4_GENERIC_DESC(
        M4_ALIAS(gausFilt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_gausFilt_dyn_t gausFilt;
    /* M4_GENERIC_DESC(
        M4_ALIAS(bifilt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_bifilt_dyn_t bifilt;
    /* M4_GENERIC_DESC(
        M4_ALIAS(inPixSgm),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_inPixSgm_dyn_t inPixSgm;
    /* M4_GENERIC_DESC(
        M4_ALIAS(textureDct),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_textureDct_dyn_t textureDct;
    /* M4_GENERIC_DESC(
        M4_ALIAS(sharpOpt),
        M4_TYPE(struct),
        M4_UI_MODULE(normal_ui_style),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_sharpOpt_dyn_t sharpOpt;
} sharp_params_dyn_t;

typedef struct {
    /* M4_GENERIC_DESC(
        M4_ALIAS(sta),
        M4_TYPE(struct),
        M4_UI_MODULE(static_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_params_static_t sta;
    /* M4_GENERIC_DESC(
        M4_ALIAS(dyn),
        M4_TYPE(struct),
        M4_UI_MODULE(dynamic_ui),
        M4_HIDE_EX(0),
        M4_RO(0),
        M4_ORDER(1),
        M4_NOTES(TODO))  */
    sharp_params_dyn_t dyn;
} sharp_param_t;

#endif
